import javax.swing.JPanel;
import java.awt.*;
import java.awt.geom.*;

public class VehicleView extends JPanel {
	private Path2D.Double vehicle;
	private VehicleModel model;

	public VehicleView( VehicleModel m, int w, int h) {
		model= m;
		setPreferredSize( new Dimension( w, h ));
		vehicle= new Path2D.Double();
		vehicle.moveTo(-10, 0);
		vehicle.lineTo(10, 0);
		vehicle.lineTo(5, -5);
		vehicle.moveTo(10, 0);
		vehicle.lineTo(5, 5);
	}
	
	public void paintComponent( Graphics g ) {
		super.paintComponent( g );
		Graphics2D g2= (Graphics2D) g;
		g2.setPaint( Color.blue );
		g2.setStroke(new BasicStroke(2));
		g2.translate(model.getVehicleX(), model.getVehicleY() );
		g2.rotate( model.getVehicleDir() );
		g2.draw( vehicle );
	}
}